<?php

namespace Fredmarmillod\TelemetryLaravel;

use Fredmarmillod\TelemetryLaravel\Commands\TelemetryLaravelCommand;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class TelemetryLaravelServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        /*
         * This class is a Package Service Provider
         *
         * More info: https://github.com/spatie/laravel-package-tools
         */
        $package
            ->name('telemetry-laravel')
            ->hasConfigFile('telemetry')
            ->hasViews('telemetry')
            ->hasMigration('create_telemetry_laravel_table')
            ->hasCommand(TelemetryLaravelCommand::class)
            ->hasRoute('web');
    }

    public function packageRegistered()
    {
        $this->app->singleton('telemetry', function () {
            return new Telemetry();
        });
    }
}
