<?php

namespace Fredmarmillod\TelemetryLaravel\Http\Controllers;

use Fredmarmillod\TelemetryLaravel\Models\TelemetryRequest;
use Illuminate\Routing\Controller;
use Illuminate\Support\Carbon;

class TelemetryController extends Controller
{
    public function index()
    {
        $data = request()->validate([
            'start_date' => 'nullable|date',
            'start_time' => 'nullable|date_format:H:i',
            'end_date' => 'nullable|date',
            'end_time' => 'nullable|date_format:H:i',
        ]);

        $startTime = $data['start_time'] ?? '00:00';
        $endTime = $data['end_time'] ?? '23:59';

        $from = ! empty($data['start_date'])
            ? Carbon::parse($data['start_date'].' '.$startTime)
            : Carbon::now()->startOfDay();

        $to = ! empty($data['end_date'])
            ? Carbon::parse($data['end_date'].' '.$endTime)
            : Carbon::now()->endOfDay();

        return view('telemetry::index', [
            'requests' => TelemetryRequest::query()
                ->with('logs')
                ->whereBetween('created_at', [$from, $to])
                ->latest()
                ->paginate(100),
            'from' => $from,
            'to' => $to,
        ]);
    }

    public function show(TelemetryRequest $request)
    {
        return view('telemetry::show', [
            'request' => $request,
        ]);
    }
}
