<?php

namespace Fredmarmillod\TelemetryLaravel;

use Fredmarmillod\TelemetryLaravel\Models\TelemetryRequest;

class Telemetry
{
    public static $request;

    public static $start;

    public static function init($request)
    {
        self::$request = TelemetryRequest::create([
            'method' => $request->method(),
            'path' => $request->path(),
            'headers' => $request->headers->all(),
            'user_agent' => $request->userAgent(),
            'data' => $request->all(),
            'ip' => $request->ip(),
            'user' => $request->user()?->only(config('telemetry.user_fields')),
        ]);

        self::$start = hrtime(true);
    }

    public static function log($name, $data)
    {
        self::$request->logs()->create([
            'type' => 'log',
            'name' => $name,
            'data' => $data,
        ]);
    }

    public static function response($response)
    {
        self::$request->update([
            'status' => $response->status(),
            'response' => config('telemetry.store_reponse') ? $response->getContent() : null,
            'exception' => $response->exception?->getMessage(),
            'duration' => (hrtime(true) - self::$start) / 1000000,
        ]);
    }
}
