<?php

namespace Fredmarmillod\TelemetryLaravel\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class TelemetryRequest extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'headers' => 'json',
        'data' => 'json',
        'user' => 'json',
        'response' => 'json',
    ];

    public function getConnectionName()
    {
        return config('telemetry.database_connection');
    }

    public function logs(): HasMany
    {
        return $this->hasMany(TelemetryLog::class);
    }
}
