<?php

namespace Fredmarmillod\TelemetryLaravel\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TelemetryLog extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'data' => 'json',
    ];

    public function getConnectionName()
    {
        return config('telemetry.database_connection');
    }

    public function request()
    {
        return $this->belongsTo(TelemetryRequest::class);
    }
}
