<?php

namespace Fredmarmillod\TelemetryLaravel\Http\Middlewares;

use Closure;
use Fredmarmillod\TelemetryLaravel\Facades\Telemetry;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class LogRequest
{
    protected array $except = [
        'telemetry*',
    ];

    public function __construct()
    {
        $this->except = array_merge($this->except, config('telemetry.except', []));
    }

    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (! config('telemetry.enabled') || $request->is($this->except)) {
            return $next($request);
        }

        Telemetry::init($request);

        $response = $next($request);

        Telemetry::response($response);

        return $response;
    }
}
