<?php

namespace Fredmarmillod\TelemetryLaravel\Commands;

use Fredmarmillod\TelemetryLaravel\Models\TelemetryRequest;
use Illuminate\Console\Command;

class TelemetryLaravelCommand extends Command
{
    public $signature = 'telemetry:purge';

    public $description = 'Purge the telemetry data.';

    public function handle(): int
    {
        if (empty(config('telemetry.purge_after_days'))) {
            return self::SUCCESS;
        }

        TelemetryRequest::query()
            ->with('logs')
            ->where('created_at', '<', now()->subDays(config('telemetry.purge_after_days', 30)))
            ->chunk(100, function ($requests) {
                $requests->each(function ($request) {
                    $request->logs()->delete();
                    $request->delete();
                });
            });

        return self::SUCCESS;
    }
}
