@extends('telemetry::app')

@section('content')
<div class="mb-4 text-gray-500">{{ $request->created_at }}</div>
<h1>
    <span class="text-lg bg-gray-50 border rounded px-4 py-2">{{ $request->method }}</span>

    <span class="text-lg font-semibold ml-2">{{ $request->path }}</span>
    <span class="text-base text-gray-500 ml-2">{{ (int)$request->duration }}ms</span>
</h1>

<div class="flex mt-6">
    <div class="w-1/5 text-lg/10 font-bold">Headers</div>

    <div class="w-4/5">
        <div class="max-h-72 overflow-auto text-xs bg-gray-800 text-white rounded-lg">
            <pre class="p-3">{{ json_encode($request->headers, JSON_PRETTY_PRINT) }}</pre>
        </div>
    </div>
</div>

<div class="flex mt-6">
    <div class="w-1/5 text-lg/10 font-bold">Body</div>

    <div class="w-4/5">
        <div class="max-h-72 overflow-auto text-xs bg-gray-800 text-white rounded-lg">
            <pre class="p-3">{{ json_encode($request->body ?? [], JSON_PRETTY_PRINT) }}</pre>
        </div>
    </div>
</div>

<div class="flex mt-6">
    <div class="w-1/5 text-lg/10 font-bold">User</div>

    <div class="w-4/5">
        <div class="max-h-72 overflow-auto text-xs bg-gray-800 text-white rounded-lg">
            <pre class="p-3">{{ json_encode($request->user ?? [], JSON_PRETTY_PRINT) }}</pre>
        </div>
    </div>
</div>

<div class="flex mt-6">
    <div class="w-1/5 text-lg/10 font-bold">Exception</div>

    <div class="w-4/5">
        <div class="max-h-72 overflow-auto text-xs bg-gray-800 text-white rounded-lg">
            <pre class="p-3">{{ $request->exception }}</pre>
        </div>
    </div>
</div>

<div class="flex mt-6">
    <div class="w-1/5 text-lg/10 font-bold">Logs</div>

    <div class="w-4/5">
        <div class="text-xs bg-gray-800 text-white rounded-lg">
            @foreach($request->logs as $log)
                <pre class="p-3">{{ $log->created_at }} - {{ $log->name }}
{{ json_encode($log->data ?? [], JSON_PRETTY_PRINT) }}</pre>
            @endforeach
        </div>
    </div>
</div>
@endsection
