@extends('telemetry::app')

@section('content')
<h1 class="text-lg font-bold">Requests</h1>

<form class="flex gap-6 mt-8">
    <div>
        <span class="block font-bold">From</span>
        <input type="date" name="start_date" class="border-gray-300 border rounded-md px-3 py-2 text-sm w-40" value="{{ $from->format('Y-m-d') }}">
        <input type="time" name="start_time" class="border-gray-300 border rounded-md px-3 py-2 text-sm w-40" value="{{ $from->format('H:i') }}">
    </div>

    <div>
        <span class="block font-bold">To</span>
        <input type="date" name="end_date" class="border-gray-300 border rounded-md px-3 py-2 text-sm w-40" value="{{ $to->format('Y-m-d') }}">
        <input type="time" name="end_time" class="border-gray-300 border rounded-md px-3 py-2 text-sm w-40" value="{{ $to->format('H:i') }}">
    </div>

    <div class="ml-auto">
        <span class="block font-bold">&nbsp;</span>

        <div class="flex gap-2">
            <a href="/telemetry" class="inline-block border border-gray-300 hover:border-gray-400 px-4 py-2 rounded-md text-gray-900">Clear</a>
            <button type="submit" class="bg-indigo-600 border border-indigo-600 hover:bg-indigo-700 px-4 py-2 rounded-md text-white">Filter</button>
        </div>
    </div>
</form>

<div class="mt-4 flow-root">
    <div class="-mx-4 -my-2 overflow-x-auto sm:-mx-6 lg:-mx-8">
        <div class="inline-block min-w-full py-2 align-middle sm:px-6 lg:px-8">
            <table class="min-w-full divide-y divide-gray-300">
                <thead>
                    <tr>
                        <th scope="col" class="py-3.5 pl-4 pr-3 text-left text-sm font-semibold text-gray-900 sm:pl-0 w-0">Date</th>
                        <th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-900 w-0">IP</th>
                        <th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-900">Path</th>
                        <th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-900">Duration</th>
                        <th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-900">Status</th>
                    </tr>
                </thead>

                <tbody class="divide-y divide-gray-200">
                    @foreach($requests as $request)
                        <tr class="hover:bg-gray-50 cursor-pointer" onclick="window.location.href = '/telemetry/{{ $request->id }}'">
                            <td class="whitespace-nowrap pr-3 py-4 text-sm  text-gray-900">{{ $request->created_at }}</td>
                            <td class="whitespace-nowrap px-3 py-4 text-sm text-gray-900">{{ $request->ip }}</td>
                            <td class="whitespace-nowrap px-3 py-4 text-sm text-gray-500">
                                <span class="bg-gray-50 border px-1 py-0.5 rounded text-xs mr-2">{{ $request->method }}</span>
                                {{ $request->path }}
                            </td>
                            <td class="whitespace-nowrap px-3 py-4 text-sm text-gray-500">{{ (int)$request->duration }}ms</td>
                            <td class="whitespace-nowrap px-3 py-4 text-sm text-gray-500">{{ $request->status }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

            <div class="mt-4">
                {{ $requests->links() }}
            </div>
        </div>
    </div>
</div>
@endsection
