# telemetry-laravel

[![Latest Version on Packagist](https://img.shields.io/packagist/v/fredmarmillod/telemetry-laravel.svg?style=flat-square)](https://packagist.org/packages/fredmarmillod/telemetry-laravel)
[![GitHub Tests Action Status](https://img.shields.io/github/actions/workflow/status/fredmarmillod/telemetry-laravel/run-tests.yml?branch=main&label=tests&style=flat-square)](https://github.com/fredmarmillod/telemetry-laravel/actions?query=workflow%3Arun-tests+branch%3Amain)
[![GitHub Code Style Action Status](https://img.shields.io/github/actions/workflow/status/fredmarmillod/telemetry-laravel/fix-php-code-style-issues.yml?branch=main&label=code%20style&style=flat-square)](https://github.com/fredmarmillod/telemetry-laravel/actions?query=workflow%3A"Fix+PHP+code+style+issues"+branch%3Amain)
[![Total Downloads](https://img.shields.io/packagist/dt/fredmarmillod/telemetry-laravel.svg?style=flat-square)](https://packagist.org/packages/fredmarmillod/telemetry-laravel)

This package adds enhanced access logs to your Laravel application.

## Installation

You can install the package via composer:

```bash
composer require fredmarmillod/telemetry-laravel
```

You can publish and run the migrations with:

```bash
php artisan vendor:publish --tag="telemetry-laravel-migrations"
php artisan migrate
```

You can publish the config file with:

```bash
php artisan vendor:publish --tag="telemetry-laravel-config"
```

This is the contents of the published config file:

```php
return [

   'enabled' => env('TELEMETRY_ENABLED', true),

    'database_connection' => 'sqlite',

    'user_fields' => [
        'id',
        'name',
        'email',
    ],

    'except' => [],

    'store_response' => false,

    'purge_after_days' => 14,

];
```

## Database Configuration

By default, the package uses the 'sqlite' connection to store the logs. You can change this by modifying the `database_connection` key in the config file.

## Usage

First, you should add the `\Fredmarmillod\TelemetryLaravel\Http\Middlewares\LogRequests` middleware to your `app/Http/Kernel.php` file:

```php
use Fredmarmillod\TelemetryLaravel\Http\Middlewares\LogRequests;

protected $middlewareGroups = [
    'web' => [
        // ...
        LogRequest::class,
    ],
    // ...
];
```

This will log all requests to the `web` middleware group. If you want to log requests to the `api` middleware group, you should add the `LogsRequests` middleware to the `api` middleware group.

Then you can attach logs to the current request:

```php
use Fredmarmillod\TelemetryLaravel\Facades\Telemetry;

Telemetry::log('This is a log message', [
    'some' => 'data',
]);
```

## Dashboard

You can view the dashboard by visiting `/telemetry` in your browser.

## Purge

You can purge old logs by running the following command:

```bash
php artisan telemetry:purge
```

This will delete all logs older than the `purge_after_days` value in the config file. You can add this command to your scheduler to run it automatically.

```php
// app/Console/Kernel.php

protected function schedule(Schedule $schedule)
{
    $schedule->command('telemetry:purge')->daily();
}
```

## Testing

```bash
composer test
```

## Changelog

Please see [CHANGELOG](CHANGELOG.md) for more information on what has changed recently.

## Contributing

Please see [CONTRIBUTING](CONTRIBUTING.md) for details.

## Security Vulnerabilities

Please review [our security policy](../../security/policy) on how to report security vulnerabilities.

## Credits

- [fredmarmillod](https://github.com/fredmarmillod)
- [All Contributors](../../contributors)

## License

The MIT License (MIT). Please see [License File](LICENSE.md) for more information.
