<?php

use FirstpointCh\Shop\Models\Region;
use FirstpointCh\Shop\Models\ShippingMethod;
use Illuminate\Support\Collection;

it('belongs to many regions', function () {
    $shippingMethod = ShippingMethod::factory()->create();
    $region = Region::factory()->create();

    $shippingMethod->regions()->attach($region, [
        'price' => 123,
    ]);

    $this->assertCount(1, $shippingMethod->regions);
    $this->assertInstanceOf(Collection::class, $shippingMethod->regions);
    $this->assertInstanceOf(Region::class, $shippingMethod->regions->first());
    $this->assertEquals(123, $shippingMethod->regions()->first()->pivot->price);
});
