<?php

use Illuminate\Routing\Router;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Str;

it('registers a localized macro', function () {
    $this->assertTrue(Router::hasMacro('localized'));
});

it('registers routes in multiple languages', function () {
    config([
        'app.fallback_locale' => 'en',
        'shop.locales' => [
            'en' => [
                'name' => 'English',
                'base_path' => '/',
            ],
            'fr' => [
                'name' => 'Français',
                'base_path' => '/fr',
            ],
        ],
    ]);

    Route::localized('test', fn () => true, 'test.route');

    $routes = array_values(array_filter(
        Route::getRoutes()->getRoutes(),
        fn (\Illuminate\Routing\Route $route) => Str::contains($route->getName(), 'test.route')
    ));

    $this->assertCount(2, $routes);

    $this->assertEquals('test', $routes[0]->uri);
    $this->assertEquals('en.test.route', $routes[0]->getName());

    $this->assertEquals('fr/test', $routes[1]->uri);
    $this->assertEquals('fr.test.route', $routes[1]->getName());
});

// TODO: test that the routes are properly translated from translation files
