<?php

use FirstpointCh\Shop\Models\Product;
use FirstpointCh\Shop\Models\ProductType;
use FirstpointCh\Shop\Models\TaxRule;

it('filters published products', function () {
    $draft = Product::factory()->create(['status' => 'draft']);
    $published = Product::factory()->create(['status' => 'published']);

    expect(Product::get())->toHaveCount(2);
    expect(Product::published()->get())->toHaveCount(1);
    expect(Product::published()->first())->toMatchArray(['id' => $published->id]);
});

it('load the total tax rate', function () {
    $productType = ProductType::factory()->create();
    $product = Product::factory()->create([
        'product_type_id' => $productType->id,
    ]);

    expect(Product::withTotalTaxRate()->first()->total_tax_rate)->toBeNull();

    $taxRule = TaxRule::factory()->create([
        'apply_to_all_regions' => true,
        'apply_to_all_product_types' => true,
        'rate' => 12,
    ]);

    expect(Product::withTotalTaxRate()->first()->total_tax_rate)->toBe(12.0);

    $taxRule->update([
        'apply_to_all_regions' => true,
        'apply_to_all_product_types' => false,
    ]);

    expect(Product::withTotalTaxRate()->first()->total_tax_rate)->toBeNull();

    $taxRule->productTypes()->attach($productType->id);

    expect(Product::withTotalTaxRate()->first()->total_tax_rate)->toBe(12.0);

    $taxRule->update([
        'apply_to_all_regions' => false,
        'apply_to_all_product_types' => true,
    ]);

    expect(Product::withTotalTaxRate()->first()->total_tax_rate)->toBeNull();

    $taxRule->regions()->attach(defaultRegion()->id);

    expect(Product::withTotalTaxRate()->first()->total_tax_rate)->toBe(12.0);
});
