<?php

use FirstpointCh\Shop\Models\Region;
use Inertia\Testing\AssertableInertia;

it('shows the region edit form', function () {
    $region = Region::factory()->create();

    $this->get('/cp/regions/'.$region->id.'/edit')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Region/Form')
            ->where('region.id', $region->id)
        );
});

test('the name is required', function () {
    $region = Region::factory()->create();

    $this->post('/cp/regions/'.$region->id)->assertStatus(302)->assertSessionHasErrors('name');
});

test('the slug is required', function () {
    $region = Region::factory()->create();

    $this->post('/cp/regions/'.$region->id)->assertStatus(302)->assertSessionHasErrors('slug');
});

test('the currency is required and must have a length of 3 chars', function () {
    $region = Region::factory()->create();

    $this->post('/cp/regions/'.$region->id)->assertStatus(302)->assertSessionHasErrors('currency');
    $this->post('/cp/regions/'.$region->id, ['currency' => 'test'])->assertStatus(302)->assertSessionHasErrors('currency');
    $this->post('/cp/regions/'.$region->id, ['currency' => 'tes'])->assertStatus(302)->assertSessionDoesntHaveErrors('currency');
});

test('the currency_format is required', function () {
    $region = Region::factory()->create();

    $this->post('/cp/regions/'.$region->id)->assertStatus(302)->assertSessionHasErrors('currency_format');
});

test('available countries is required', function () {
    $region = Region::factory()->create();

    $this->post('/cp/regions/'.$region->id)->assertStatus(302)->assertSessionHasErrors('available_countries');
});

test('each available country must have a length of 2 chars', function () {
    $region = Region::factory()->create();

    $this->post('/cp/regions/'.$region->id, [
        'available_countries' => ['abc', 'de'],
    ])
    ->assertStatus(302)
    ->assertSessionHasErrors('available_countries.0')
    ->assertSessionDoesntHaveErrors('available_countries.1');
});

it('updates a region', function () {
    $region = Region::factory()->create([
        'name' => 'Name',
        'slug' => 'slug',
        'currency' => 'CHF',
        'currency_format' => 'de_CH',
        'available_countries' => ['CH'],
    ]);

    $data = [
        'name' => 'New name',
        'slug' => 'new-slug',
        'currency' => 'EUR',
        'currency_format' => 'fr_FR',
        'available_countries' => ['FR'],
    ];

    $this->post('/cp/regions/'.$region->id, $data)
        ->assertStatus(302)
        ->assertRedirect('/cp/regions');

    $data['available_countries'] = json_encode($data['available_countries']);

    $this->assertDatabaseHas('regions', $data);
});
