<?php

use FirstpointCh\Shop\Models\Product;
use FirstpointCh\Shop\Models\Variant;
use Inertia\Testing\AssertableInertia;

it('shows variants for a product', function () {
    $product = Product::factory()->create();
    $variant = Variant::factory()->create([
        'product_id' => $product->id,
    ]);

    Variant::factory()->create(); // This variant should not be shown in the index

    $this->get('/cp/products/'.$product->id.'/variants')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Product/Show')
            ->has('variants.data', 1)
            ->where('variants.data.0.id', $variant->id)
        );
});
