<?php

use FirstpointCh\Shop\Models\Product;
use FirstpointCh\Shop\Models\ProductType;

it('deletes a product with all relations', function () {
    $productType = ProductType::factory()->create();
    $product = Product::factory()->create([
        'product_type_id' => $productType->id,
    ]);

    $this->delete('/cp/products/'.$product->id)
        ->assertStatus(302);

    $this->assertDatabaseMissing('products', [
        'id' => $product->id,
    ]);

    $this->assertDatabaseMissing('variants', [
        'product_id' => $product->id,
    ]);

    // TODO: Check for categories, tax rules, pictures, etc.
});
