<?php

use FirstpointCh\Shop\Models\Coupon;
use Inertia\Testing\AssertableInertia;

it('shows the coupons index', function () {
    $coupon = Coupon::factory()->create();

    $this->get('/cp/coupons')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Coupon/Index')
            ->has('coupons.data', 1)
            ->where('coupons.data.0.code', $coupon->code)
        );
});

it('searches attributes by name', function () {
    $firstCoupon = Coupon::factory()->create([
        'name' => 'First coupon',
    ]);

    $secondCoupon = Coupon::factory()->create([
        'name' => 'Second coupon',
    ]);

    datatableSearch('/cp/coupons', 'First coupon')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Coupon/Index')
            ->has('coupons.data', 1)
            ->where('coupons.data.0.id', $firstCoupon->id)
        );

    datatableSearch('/cp/coupons', 'Second coupon')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Coupon/Index')
            ->has('coupons.data', 1)
            ->where('coupons.data.0.id', $secondCoupon->id)
        );

    datatableSearch('/cp/coupons', 'coupon')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Coupon/Index')
            ->has('coupons.data', 2)
        );
});

// TODO: it searches by code
