<?php

namespace FirstpointCh\Shop\Observers;

use FirstpointCh\Shop\Events\OrderCancelled;
use FirstpointCh\Shop\Events\OrderPaid;
use FirstpointCh\Shop\Models\Order;
use FirstpointCh\Shop\Order\Enums\OrderStatus;

class OrderObserver
{
    public function updated(Order $order)
    {
        if ($changes = $order->getChanges()) {
            if (array_key_exists('status', $changes)) {
                if (OrderStatus::from($changes['status']) === OrderStatus::Paid) {
                    $this->onPaid($order);
                } elseif (OrderStatus::from($changes['status']) === OrderStatus::Cancelled) {
                    $this->onCancelled($order);
                }
            }
        }
    }

    private function onPaid(Order $order)
    {
        $order->activities()->create([
            'user_name' => $order->first_name.' '.$order->last_name,
            'action_type' => 'flow',
            'action_title' => 'a payé sa commande',
        ]);

        try { // In case there's an error in a listener
            OrderPaid::dispatch($order);
        } catch (\Exception $e) {
            //
        }
    }

    private function onCancelled(Order $order)
    {
        $order->activities()->create([
            'user_name' => $order->first_name.' '.$order->last_name,
            'action_type' => 'flow',
            'action_title' => 'a annulé sa commande',
        ]);

        try { // In case there's an error in a listener
            OrderCancelled::dispatch($order);
        } catch (\Exception $e) {
            //
        }
    }
}
