<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Shop\Traits\HasPackageFactory;
use Illuminate\Database\Eloquent\Model;

class Shipment extends Model
{
    use HasPackageFactory;

    protected $guarded = [];

    protected $casts = [
        'meta' => 'json',
    ];

    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    public function getCarrier()
    {
        return app('shop::carriers')->get($this->carrier);
    }
}
