<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Shop\Traits\HasPackageFactory;
use Illuminate\Database\Eloquent\Model;

class Address extends Model
{
    use HasPackageFactory;

    protected $guarded = [];

    protected static function newFactory()
    {
        return new \FirstpointCh\Shop\Database\Factories\AddressFactory;
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }
}
