<?php

namespace FirstpointCh\Shop\Http\Controllers\Cp;

use FirstpointCh\Shop\Http\Controllers\Controller;
use FirstpointCh\Shop\Models\Order;
use FirstpointCh\Shop\Models\Shipment;

class OrderShipmentController extends Controller
{
    public function store(Order $order)
    {
        $data = request()->validate([
            'carrier' => 'required|string', // TODO: check that the carrier exists
            'meta' => 'nullable|array',
        ]);

        $order->shipments()->create($data);

        return redirect()->back();
    }

    public function print(Order $order, Shipment $shipment)
    {
        $carrier = $shipment->getCarrier();

        return $carrier->exportLabel($shipment);
    }

    public function destroy(Order $order, Shipment $shipment)
    {
        $shipment->delete();

        return redirect()->back();
    }
}
