<?php

namespace FirstpointCh\Shop\Http\Controllers\Cp;

use FirstpointCh\Shop\Http\Controllers\Controller;
use FirstpointCh\Shop\Http\Requests\DatatableRequest;
use FirstpointCh\Shop\Models\Category;
use Inertia\Inertia;

class CategoryController extends Controller
{
    public function index(DatatableRequest $datatable)
    {
        return Inertia::render('Category/Index', [
            'categories' => Category::whereNull('parent_id')->with('children')->get(),
            'datatableState' => $datatable->getState(),
        ]);
    }

    public function create()
    {
        $categories = Category::whereNull('parent_id')->with('children')->get();

        return Inertia::render('Category/Form', [
            'categories' => $categories,
        ]);
    }

    public function store()
    {
        Category::create(request()->validate([
            'slug' => 'required',
            'name' => 'required',
            'is_active' => 'required',
            'parent_id' => 'nullable',
        ]));

        return redirect('/cp/categories');
    }

    public function edit(Category $category)
    {
        $categories = Category::whereNull('parent_id')->with('children')->get();

        return Inertia::render('Category/Form', [
            'category' => $category->in('*'),
            'categories' => $categories,
        ]);
    }

    public function update(Category $category)
    {
        $category->update(request()->validate([
            'slug' => 'required',
            'name' => 'required',
            'is_active' => 'required',
            'parent_id' => 'nullable',
        ]));

        return redirect('/cp/categories');
    }
}
