<?php

namespace FirstpointCh\Shop\Http\Controllers\Cp;

use FirstpointCh\Shop\Http\Controllers\Controller;
use FirstpointCh\Shop\Http\Requests\DatatableRequest;
use FirstpointCh\Shop\Models\Attribute;
use Illuminate\Support\Arr;
use Inertia\Inertia;

class AttributeController extends Controller
{
    public function index(DatatableRequest $datatable)
    {
        return Inertia::render('Attribute/Index', [
            'attributes' => $datatable
                ->searchable(['name'])
                ->query(Attribute::query())
                ->get(),
            'datatableState' => $datatable->getState(),
        ]);
    }

    public function create()
    {
        return Inertia::render('Attribute/Form', [
            'customFieldTypes' => app('shop::shop')->getAttributeTypes(),
        ]);
    }

    public function store()
    {
        $data = request()->validate([
            'key' => 'required|max:255',
            'name' => 'required',
            'type' => 'required',
            'translatable' => 'boolean',
            'options' => 'nullable|array',
        ]);

        $options = Arr::pull($data, 'options', []);

        $attribute = Attribute::create($data);
        $attribute->options()->createMany($options);

        return redirect('/cp/attributes');
    }

    public function edit(Attribute $attribute)
    {
        $attribute->load('options');
        $attribute->options->map->in('*');

        return Inertia::render('Attribute/Form', [
            'attr' => $attribute->in('*'),
            'customFieldTypes' => app('shop::shop')->getAttributeTypes(),
        ]);
    }

    public function update(Attribute $attribute)
    {
        $data = request()->validate([
            'key' => 'required|max:255',
            'name' => 'required',
            'type' => 'required',
            'translatable' => 'boolean',
            'options' => 'array',
        ]);

        $options = Arr::pull($data, 'options');

        $attribute->update($data);

        foreach ($options as $option) {
            if (! empty($option['id'])) {
                $attribute->options()->find($option['id'])->update($option);
            } else {
                $attribute->options()->create($option);
            }
        }

        return redirect('/cp/attributes');
    }
}
