<?php

namespace FirstpointCh\Shop\Commands;

use FirstpointCh\Shop\Models\CatalogIndex as Index;
use FirstpointCh\Shop\Models\Product;
use Illuminate\Console\Command;

class CatalogIndex extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'catalog:index';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Reindex catalog';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        Index::truncate();

        Product::with('attributes', 'variants.regions')->chunk(100, function ($products) {
            $products->each->index();
        });

        return 0;
    }
}
