# Pages

As you may have noticed, after installing the shop, this directory has been created: ```resources/views/cms-templates```.

There you can create blade templates that can be used as CMS pages. Each template must have a corresponding yaml file that defines the fieldset to use.

**resources/views/cms-templates/about.blade.php**

```blade
<x-layout.base :title="$title">
    <h1>{{ $title }}</h1>
    <p>{{ $content }}</p>
    <p>{{ $anotherVariable }}</p>
</x-layout.base>
```

**resources/views/cms-templates/about.yaml**

```yaml
fields:
  content:
    label: "Main content"
    type: wysiwyg
  anotherVariable:
    label: "Another variable"
    type: string
```
