# Product

A product is a physical or digital good that you sell. Every product has one or more variants, such as different sizes or colors. For example, a t-shirt might have variants for small, medium, and large, and each variant might have a different price. Products are not orderable, it is an entity that groups variants together and provides a common set of attributes. 

## Product model

- Name
- Status (published, draft)
- Short description
- Description

It also has some relations:

- Product type (BelongsTo)
- Brand (BelongsTo)
- Regions (BelongsToMany)
- Variants (HasMany)
- Categories (BelongsToMany)
- Tax rules (BelongsToMany)
- Attributes (BelongsToMany)

## Querying Products

### Global scopes

When the shop is "region aware", an Eloquent global scope is applied to the `Product` model to only return products that are available in the current region.

### Filter products

The product model has some utility scopes to filter products. Here some examples:

```php
$products = Product::query()
    ->whereCategoriesIn([1, 2, 3]) // Filter by categories
    ->wherePriceBetween(10, 100)   // Filter by price
    // TODO: Add more filters
    ->get();
```
