<?php

use FirstpointCh\Shop\Events\OrderCancelled;
use FirstpointCh\Shop\Events\OrderPaid;
use FirstpointCh\Shop\Models\Order;
use FirstpointCh\Shop\Order\Enums\OrderStatus;
use Illuminate\Support\Facades\Event;

it('dispatches an event when an order is cancelled', function () {
    Event::fake([OrderCancelled::class]);

    $order = Order::factory()->createQuietly();

    $order->update([
        'status' => OrderStatus::Cancelled,
    ]);

    Event::assertDispatched(function (OrderCancelled $event) use ($order) {
        return $event->order->is($order);
    });
});

it('dispatches an event when an order is paid', function () {
    Event::fake([OrderPaid::class]);

    $order = Order::factory()->createQuietly();

    $order->update([
        'status' => OrderStatus::Paid,
    ]);

    Event::assertDispatched(function (OrderPaid $event) use ($order) {
        return $event->order->is($order);
    });
});
