import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';
import vue from '@vitejs/plugin-vue';
import { viteExternalsPlugin } from 'vite-plugin-externals'

export default defineConfig({
    plugins: [
        laravel([
            'resources/css/cp.css',
            'resources/js/app.js',
        ]),
        vue({
            template: {
                transformAssetUrls: {
                    base: null,
                    includeAbsolute: false,
                },
            },
        }),
        viteExternalsPlugin({
            vue: 'Vue',
        }),
    ],
    resolve: {
        alias: {
            '@': '/resources/js',
        },
    },
});
