<?php

use FirstpointCh\Shop\Models\Region;
use FirstpointCh\Shop\Models\Variant;

it('filters active variants', function () {
    $inactive = Variant::factory()->create(['is_active' => false]);
    $active = Variant::factory()->create(['is_active' => true]);

    expect(Variant::get())->toHaveCount(2);
    expect(Variant::active()->get())->toHaveCount(1);
    expect(Variant::active()->first())->toMatchArray(['id' => $active->id]);
});

it('loads the variant price', function () {
    $region1 = Region::factory()->create();
    $region2 = Region::factory()->create();
    $variant = Variant::factory()->create();

    $variant->regions()->attach($region1->id, ['price' => 10, 'product_id' => $variant->product_id]);
    $variant->regions()->attach($region2->id, ['price' => 20, 'product_id' => $variant->product_id]);

    // It takes the current region if region aware
    shop()->regionAware();
    shop()->setRegion($region1);
    expect(Variant::withPrice()->find($variant->id)->price)->toBe(10);

    shop()->setRegion($region2);
    expect(Variant::withPrice()->find($variant->id)->price)->toBe(20);
});
