<?php

use Inertia\Testing\AssertableInertia;

it('shows the coupon create form', function () {
    $this->get('/cp/coupons/create')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Coupon/Form')
        );
});

test('the name is required', function () {
    $this->post('/cp/coupons')->assertStatus(302)->assertSessionHasErrors('name');
});

test('the code is required', function () {
    $this->post('/cp/coupons')->assertStatus(302)->assertSessionHasErrors('code');
});

test('the type is required and be fixed_amount or percentage', function () {
    $this->post('/cp/coupons')->assertStatus(302)->assertSessionHasErrors('type');
    $this->post('/cp/coupons', ['type' => 'fixed_amount'])->assertStatus(302)->assertSessionDoesntHaveErrors('type');
    $this->post('/cp/coupons', ['type' => 'percentage'])->assertStatus(302)->assertSessionDoesntHaveErrors('type');
    $this->post('/cp/coupons', ['type' => 'unknown_type'])->assertStatus(302)->assertSessionHasErrors('type');
});

test('the value is required', function () {
    $this->post('/cp/coupons')->assertStatus(302)->assertSessionHasErrors('value');
});

// TODO: active_from and active_to
