<?php

use FirstpointCh\Shop\Models\Brand;
use Inertia\Testing\AssertableInertia;

it('shows the brand index', function () {
    $brand = Brand::factory()->create();

    $this->get('/cp/brands')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Brand/Index')
            ->has('brands.data', 1)
            ->where('brands.data.0.id', $brand->id)
        );
});

it('searches brand by name', function () {
    $firstBrand = Brand::factory()->create([
        'name' => 'First brand',
    ]);

    $secondBrand = Brand::factory()->create([
        'name' => 'Second brand',
    ]);

    datatableSearch('/cp/brands', 'First brand')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Brand/Index')
            ->has('brands.data', 1)
            ->where('brands.data.0.id', $firstBrand->id)
        );

    datatableSearch('/cp/brands', 'Second brand')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Brand/Index')
            ->has('brands.data', 1)
            ->where('brands.data.0.id', $secondBrand->id)
        );

    datatableSearch('/cp/brands', 'brand')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Brand/Index')
            ->has('brands.data', 2)
        );
});
