<?php

namespace FirstpointCh\Shop;

use FirstpointCh\Shop\Models\Region;

class Shop
{
    protected ?Region $currentRegion;

    protected $regionAware = false;

    private $cpScripts = [];

    public function __construct(string $region)
    {
        $this->currentRegion = Region::where('slug', $region)->first();
    }

    public function getRegion(): ?Region
    {
        return $this->currentRegion;
    }

    public function setRegion($region)
    {
        if ($region instanceof Region) {
            $this->currentRegion = $region;
        } elseif (is_string($region) && $region) {
            if ($region === $this->currentRegion->slug) {
                return;
            }

            $this->currentRegion = Region::where('slug', $region)->first();

            if (empty($this->currentRegion)) {
                throw new \Exception('Invalid region "'.$region.'"');
            }
        } elseif (is_int($region)) {
            $this->currentRegion = Region::find($region);
        } else {
            throw new \Exception('Invalid region "'.$region.'"');
        }
    }

    public function isRegionAware()
    {
        return $this->regionAware;
    }

    public function regionAware($value = true)
    {
        $this->regionAware = $value;

        return $this;
    }

    public function registerScripts(array $paths)
    {
        $this->cpScripts = array_merge($this->cpScripts, $paths);
    }

    public function getCpScripts()
    {
        return $this->cpScripts;
    }
}
