<?php

namespace FirstpointCh\Shop\Payment\Gateway;

use FirstpointCh\Shop\Models\Payment;
use FirstpointCh\Shop\Payment\Enums\GatewayStatus;
use Illuminate\Http\Request;

abstract class PaymentGateway
{
    public Payment $payment;

    protected string $error;

    public function init(Payment $payment)
    {
        //
    }

    abstract public static function getPaymentIntent(Request $request): Payment;

    abstract public function handle(): GatewayStatus;

    public function setError($error)
    {
        $this->error = $error;
    }

    public function getError()
    {
        return $this->error;
    }
}
