<?php

namespace FirstpointCh\Shop\Payment;

use FirstpointCh\Shop\Models\Payment;
use FirstpointCh\Shop\Payment\Gateway\PaymentGateway;
use Illuminate\Http\Request;

class Gateway
{
    protected array $gateways = [];

    public function __construct(array $gateways)
    {
        $this->gateways = $gateways;
    }

    public static function make(string $gateway): PaymentGateway
    {
        foreach (app(self::class)->gateways as $name => $concrete) {
            if ($name === $gateway) {
                return new $concrete($name);
            }
        }
    }

    public static function create(Payment $payment): PaymentGateway
    {
        foreach (app(self::class)->gateways as $gateway => $concrete) {
            if ($payment->gateway === $gateway) {
                return new $concrete($payment);
            }
        }

        throw new \Exception("Gateway does not exist: {$payment->gateway}");
    }

    public static function fromRequest($gateway, Request $request): PaymentGateway
    {
        foreach (app(self::class)->gateways as $g => $concrete) {
            if ($g === $gateway) {
                return $concrete::fromRequest($request);
            }
        }

        throw new \Exception("Gateway does not exist: {$gateway}");
    }
}
