<?php

namespace FirstpointCh\Shop\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Shipment extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'meta' => 'json',
    ];

    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    public function getCarrier()
    {
        return app('shop::carriers')->get($this->carrier);
    }
}
