<?php

namespace FirstpointCh\Shop\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Region extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded = [];

    protected $casts = [
        'available_countries' => 'array',
    ];

    public function variants()
    {
        return $this->belongsToMany(Variant::class, 'region_variant')
            ->withPivot(['price']);
    }

    public function orders()
    {
        return $this->hasMany(Order::class);
    }
}
