<?php

namespace FirstpointCh\Shop\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductType extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function products()
    {
        return $this->hasMany(Product::class);
    }

    public function productAttributes()
    {
        return $this->belongsToMany(Attribute::class)
            ->wherePivot('type', 'product')
            ->withTimestamps();
    }

    public function variantAttributes()
    {
        return $this->belongsToMany(Attribute::class)
            ->wherePivot('type', 'variant')
            ->withTimestamps();
    }

    public function taxRules()
    {
        return $this->belongsToMany(TaxRule::class)
            ->withTimestamps();
    }
}
