<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Translatable\Casts\Localized;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CatalogIndex extends Model
{
    use HasFactory;

    protected $table = 'catalog_index';

    protected $guarded = [];

    protected $casts = [
        'product_name' => Localized::class,
        'variant_name' => Localized::class,
        'product_attributes' => 'json',
        'variant_attributes' => 'json',
    ];

    protected static function booted()
    {
        static::addGlobalScope('region-aware', function ($builder) {
            $builder->when(shop()->isRegionAware(), function ($query) {
                $query->where('region_id', shop()->getRegion()->id);
            });
        });
    }

    public function region()
    {
        return $this->belongsTo(Region::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function variant()
    {
        return $this->belongsTo(Variant::class);
    }

    // public function productAttributes()
    // {
    //     return $this->belongsToMany(Attribute::class, 'attribute_product', 'product_id', 'attribute_id')
    //         ->withPivot(['value'])
    //         ->using(AttributeProduct::class);
    // }

    // public function variantAttributes()
    // {
    //     return $this->hasMany(AttributeIndex::class, 'variant_id', 'variant_id');
    // }

    // public function variantAttributes()
    // {
    //     return $this->belongsToMany(Attribute::class, 'attribute_variant', 'variant_id', 'attribute_id')
    //         ->withPivot(['value_option_id', 'value_translated', 'value_string', 'value_integer'])
    //         ->using(AttributeVariant::class);
    // }

    public function scopeOnRegion($query, $region)
    {
        $query->where('region_id', $region);
    }

    public function scopeActive($query, $region)
    {
        $query->where('product_status', 'published')->where('variant_is_active', true);
    }
}
