<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Shop\Collections\CartTaxesCollection;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CartTax extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'taxable_amount' => 'float',
        'tax_amount' => 'float',
    ];

    public function newCollection(array $models = [])
    {
        return new CartTaxesCollection($models);
    }

    public function cart()
    {
        return $this->belongsTo(Cart::class);
    }

    public function taxRule()
    {
        return $this->belongsTo(TaxRule::class);
    }
}
