<?php

namespace FirstpointCh\Shop\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class RegionAware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next, $regionSlug = null)
    {
        $regionSlug = $regionSlug ?? config('shop.default_region');

        if (! empty($regionSlug)) {
            shop()->setRegion($regionSlug);
        }

        shop()->regionAware(true);

        return $next($request);
    }
}
