<?php

namespace FirstpointCh\Shop\Http\Controllers\Cp;

use FirstpointCh\Shop\Http\Controllers\Controller;
use Illuminate\Support\Str;

class UploadController extends Controller
{
    public function store()
    {
        $data = request()->validate([
            'productId' => 'required|exists:products,id',
            'files' => 'required|array',
            'files.*' => 'required|file|mimes:jpeg,png,jpg,gif,svg|max:4096',
        ]);

        $paths = [];

        foreach ($data['files'] as $file) {
            $filename = Str::uuid().'.'.$file->extension();
            $paths[] = $file->storeAs('products'.DIRECTORY_SEPARATOR.$data['productId'], $filename, 'public');
        }

        return $paths;
    }
}
