<?php

namespace FirstpointCh\Shop\Http\Controllers\Cp;

use FirstpointCh\Shop\Http\Controllers\Controller;
use FirstpointCh\Shop\Http\Requests\DatatableRequest;
use FirstpointCh\Shop\Models\Order;
use Inertia\Inertia;

class OrderController extends Controller
{
    public function index(DatatableRequest $datatable)
    {
        return Inertia::render('Order/Index', [
            'orders' => $datatable
                ->searchable(['first_name', 'last_name', 'email'])
                ->performQuery(
                    Order::with('activities')->when(
                        request('filters.status'),
                        fn ($query) => $query->where('status', request('filters.status'))
                    )
                ),
            'datatableState' => $datatable->getState(),
        ]);
    }

    public function show(Order $order)
    {
        money()->setFormat($order->currency);

        $order->load(['customer', 'payments', 'items', 'taxes', 'activities', 'shipments']);

        return Inertia::render('Order/Show', [
            'order' => $order,
            'subtotal' => money()->format($order->items->subtotal()),
            'total' => money()->format($order->totalAmount()),
            'carriers' => app('shop::carriers')->all(),
        ]);
    }

    public function update(Order $order)
    {
        $data = request()->validate([
            'status' => 'required|in:pending,paid,shipped,cancelled',
        ]);

        $order->update($data);

        return redirect()->back()->with('toast', [
            'title' => 'Commande enregistrée',
            'message' => 'La commande a bien été enregistrée',
            'type' => 'success',
        ]);
    }
}
