<?php

namespace FirstpointCh\Shop\Data\Cp;

use FirstpointCh\Shop\Models\Attribute;
use Spatie\LaravelData\Data;

class ProductAttributeData extends Data
{
    public function __construct(
        public int $attribute_id,
        public string $name,
        public string $type,
        public $options,
        public $value_option_id = null,
        public $value_translated = null,
        public $value_string = null,
        public $value_integer = null,
    ) {
    }

    public static function fromModel(Attribute $attribute): self
    {
        $attribute->pivot->in('*');

        return new self(
            $attribute->id,
            $attribute->name,
            $attribute->type,
            $attribute->options->map->in('*'),
            $attribute->pivot->value_option_id,
            $attribute->pivot->value_translated,
            $attribute->pivot->value_string,
            $attribute->pivot->value_integer,
        );
    }
}
