<?php

namespace FirstpointCh\Shop\Commands;

use FirstpointCh\Shop\Models\CatalogIndex as Index;
use FirstpointCh\Shop\Models\Product;
use Illuminate\Console\Command;

class CatalogIndex extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'catalog:index';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Reindex catalog';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        Index::truncate();

        Product::with('variants.regions')->chunk(100, function ($products) {
            foreach ($products as $product) {
                foreach ($product->variants as $variant) {
                    foreach ($variant->regions as $region) {
                        Index::create([
                            'region_id' => $region->id,
                            'product_id' => $product->id,
                            'product_name' => $product->name,
                            'product_status' => $product->status,
                            'variant_id' => $variant->id,
                            'variant_sku' => $variant->sku,
                            'variant_name' => $variant->name,
                            'variant_is_active' => $variant->is_active,
                            'price' => $region->pivot->price,
                            'product_attributes' => $product->attributes->mapWithKeys(function ($attribute) {
                                return [
                                    $attribute->key => match ($attribute->type) {
                                        'text' => $attribute->pivot->value_string,
                                        'translated' => $attribute->pivot->in('*')->value_translated,
                                        'integer' => $attribute->pivot->value_integer,
                                        'options' => $attribute->pivot->value_option_id,
                                    },
                                ];
                            }),
                            'variant_attributes' => $variant->attributes->mapWithKeys(function ($attribute) {
                                return [
                                    $attribute->key => match ($attribute->type) {
                                        'text' => $attribute->pivot->value_string,
                                        'translated' => $attribute->pivot->in('*')->value_translated,
                                        'integer' => $attribute->pivot->value_integer,
                                        'options' => $attribute->pivot->value_option_id,
                                    },
                                ];
                            }),
                        ]);
                    }
                }
            }
        });

        return 0;
    }
}
