<?php

namespace FirstpointCh\Shop\Cart;

use FirstpointCh\Shop\Actions\Action;
use FirstpointCh\Shop\Models\Cart;
use FirstpointCh\Shop\Models\CartItem;
use FirstpointCh\Shop\Models\TaxRule;

class UpdateCartTaxesAction
{
    use Action;

    public function handle(Cart $cart)
    {
        $cart->taxes()->delete();

        $cart->load('taxes');

        $cart->items()->each(function (CartItem $item) use ($cart) {
            TaxRule::query()
                ->forProduct($item->orderable->product)
                ->get()
                ->each(function (TaxRule $taxRule) use ($item, $cart) {
                    if ($tax = $cart->taxes()->where('tax_rule_id', $taxRule->id)->first()) {
                        $tax->increment('taxable_amount', $item->orderable->price * $item->quantity);
                    } else {
                        $cart->taxes()->create([
                            'tax_rule_id' => $taxRule->id,
                            'taxable_amount' => $item->orderable->price * $item->quantity,
                        ]);
                    }
                });
        });
    }
}
