attribute_product
- id
- attribute_id
- product_id
- type [translated, text, integer]
- value: json

AttributeValueCast

```php
public function get($model, $key, $value, $attributes)
{
    return match ($attribute->type) {
        'translated' => $this->getTranslatedValue($model, $key, $value, $attributes),
        'text' => $this->getTextValue($model, $key, $value, $attributes),
        'integer' => $this->getIntegerValue($model, $key, $value, $attributes),
        _ => $value,
    };
}

public function set($model, $key, $value, $attributes)
{
    if (! $value instanceof AddressModel) {
        throw new InvalidArgumentException('The given value is not an Address instance.');
    }

    return [
        'address_line_one' => $value->lineOne,
        'address_line_two' => $value->lineTwo,
    ];
}
```
