## Extends

### Cart

```php
// CartServiceProvider.php
public $beforeAdding = [
    CheckThatProductIsAvailable::class,
];

public $afterAdding = [];

public $calculate = [

];
```

```php
class CheckThatProductIsAvailable
{
    public function handle(Cart $cart, $item, $next)
    {
        if (! $item->product->isAvailable()) {
            throw new ProductNotAvailableException;
        }

        return $next($cart, $item);
    }
}
```

```php
Cart::add($orderable);
```
