<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('catalog_index', function (Blueprint $table) {
            $table->id();
            $table->foreignId('region_id')->constrained()->onDelete('cascade');
            $table->foreignId('product_id')->constrained()->onDelete('cascade');
            $table->json('product_name');
            $table->string('product_status');
            $table->foreignId('variant_id')->constrained()->onDelete('cascade');
            $table->string('variant_sku');
            $table->json('variant_name');
            $table->boolean('variant_is_active');
            $table->decimal('price', 10, 2);
            $table->json('product_attributes');
            $table->json('variant_attributes');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('catalog_index');
    }
};
