<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('variants', function (Blueprint $table) {
            $table->id();
            $table->translatable('name');
            $table->string('sku')->index();
            $table->boolean('is_active');
            $table->boolean('is_shippable')->default(true);
            $table->decimal('weight_grams', 10, 2)->nullable();
            $table->boolean('track_stock')->default(false);
            $table->integer('stock')->nullable();
            $table->translatable('slug');

            // Relations
            $table->foreignId('product_id')
                ->constrained()
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamps();
            $table->softDeletes();
        });
    }
};
