<?php

namespace FirstpointCh\Shop\Database\Factories;

use FirstpointCh\Shop\Models\Customer;
use FirstpointCh\Shop\Models\Order;
use FirstpointCh\Shop\Models\Payment;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class PaymentFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Payment::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'customer_id' => function () {
                return Customer::factory()->create();
            },
            'order_id' => function () {
                return Order::factory()->create();
            },
            'reference' => Str::random(10),
            'gateway' => 'testing',
            'amount' => $this->faker->numberBetween(100, 1000),
            'currency' => 'CHF',
            'status' => $this->faker->randomElement(['pending', 'paid']),
        ];
    }
}
